

#ifndef __meeting_site_storager_h__
#define __meeting_site_storager_h__

#include <string>
#include <map>
#include <list>
#include <vector>
#include <map>
#include "MeetingSiteImpl.h"
#include "csf/Timer.hpp"
#include "csf/RWLock.hpp"
#include "JabberMeetingAccountSync.h"
#include "JabberMeetingAccountCupSync.h"
#include "JabberMeetingAccountWapiSync.h"


namespace CSFUnified
{
    class MeetingSiteStorager : public newTimerCallBack, public IJabberMeetingAccountEvent
    {
        
    public:
        virtual ~MeetingSiteStorager();
        static MeetingSiteStorager * getInstance();
        
        virtual void onGetAllSite(bool isSuccess, std::list<SMART_PTR_NS::shared_ptr<MeetingSiteImpl> >& siteList);
        virtual void onGetDefaultSite(JABBER_MEETING_ACCOUNT_ERROR_CODE errorCode, std::string errorMsg, SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site, std::string sessionTicket, long keepAliveTime);
		virtual void onSetDefaultSite(JABBER_MEETING_ACCOUNT_ERROR_CODE errorCode, std::string errorMsg, SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site, std::string sessionTicket, long keepAliveTime);
        
        virtual void onTimer();
        void refreshSessionTicket();


        void start();
        void stop();
        bool isActive();
        bool isReady();
        void setReady();
        int getCount();
        SMART_PTR_NS::shared_ptr<MeetingSite> getDefaultSite();
        SMART_PTR_NS::shared_ptr<MeetingSite> getSiteByIndex(int index);
        void setActiveSite(SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site, std::string sessionTicket, long keepAliveTime);
        void deleteSite(std::string siteUrl);
        void checkSSOInfo(std::string siteUrl);
		int isSSOSite(std::string siteUrl);

		int getSiteLastError();
		std::string getSiteLastErrorMessage();
		void setLastError(int errorCode, std::string errorMsg = "");



        void setAccountSSOProperty(std::string siteUrl, bool bSSO);
        
        //get account xml
        std::string getLocalAccountXML();
        
        
        void onVerifyAccount(bool isSuccess, int lastError, int siteFlag, std::string sessionTicket, long keepAliveTime);
        void onCheckSSOSite(int result, std::string siteUrl);
        void onCheckSiteListSSOInfo();
        
        
    private:
        MeetingSiteStorager();
        void reset();
        long getLocalTickCount();
        

    private:
        bool m_isReady;
        bool m_isActive;
		bool m_isRefreshSK;
        std::string m_defaultSiteUrl;
        std::string m_sessionTicket;
        long m_sessionTicketTimeout;
        std::map<std::string, SMART_PTR_NS::shared_ptr<MeetingSiteImpl> > m_mapAccountInfo;
        
        std::map<std::string, int> m_mapSSOInfo;
        SMART_PTR_NS::shared_ptr<MeetingSiteImpl> m_inProcessMeetingSite;
        std::string m_inProcessSessionTicket;
        long m_inProcessKeepAliveTime;

        IJabberMeetingAccountSync * m_accountSync;
        JabberMeetingAccountWapiSync m_wapiSync;
        JabberMeetingAccountCupSync m_cupSync;
        
        int m_lastError;
		std::string m_lastErrorMsg;

        
        
        csf::RWLock mLock;
        csf::TimerHelper * m_timer;
    };
}

#endif//__meeting_site_storager_h__

